@extends('backend.layouts.master')

@section('title')
{{ $title }}
@endsection

@section('css')
<link rel="stylesheet" href="{{ asset('backend/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css') }}">
<link rel="stylesheet" href="{{ asset('backend/plugins/datatables-responsive/css/responsive.bootstrap4.min.css') }}">
@endsection

@section('back-content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0 text-dark">{{ $title }}</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item active">All {{ $title }}</li>
                </ol>
            </div>
        </div>
    </div>
</div>
<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12 col-12">
                <form action="{{ route('admin.custom-script.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="card card-success">
                        <div class="card-header">
                            <h3 class="card-title">New Script</h3>
                        </div>
                        <div class="card-body">
                            <div class="form-group">
                                <label for="type">Type</label>
                                <select class="form-control" name="type" id="type">
                                    <option value="Head">Head</option>
                                    <option value="Body">Body</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="script">Script</label>
                                <textarea class="form-control" name="script" id="script" cols="30" rows="3"></textarea>
                            </div>
                        </div>
                        <div class="card-footer text-center">
                            <button type="submit" class="btn btn-primary">Submit</button>
                        </div>
                    </div>
                </form>
            </div>
            
            <div class="col-lg-12 col-12">
                <div class="card card-success">
                    <div class="card-header">
                        <h3 class="card-title">All {{ $title }}</h3>
                    </div>
                    <div class="card-body">
                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th width="5%">#</th>
                                    <th width="10%">Type</th>
                                    <th>Script</th>
                                    <th width="10%">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($datas as $key => $data)
                                <tr>
                                    <td>{{ $key + 1 }}</td>
                                    <td>{{ $data->type }}</td>
                                    <td>{{ $data->script }}</td>
                                    <td>
                                        <a href="javascript:;" class="btn btn-success btn-sm" data-toggle="modal" data-target="#edit_{{ $data->id }}">
                                            <i class="fas fa-edit"></i>
                                        </a>

                                        <button type="button" onclick="deleteData({{ $data->id }})" class="btn btn-danger btn-sm">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                        <form id="delete-form-{{ $data->id }}" action="{{ route('admin.custom-script.delete', $data->id) }}" method="POST" style="display: none;">
                                            @csrf
                                        </form>
                                    </td>
                                </tr>
                                <div class="modal fade" id="edit_{{ $data->id }}" tabindex="-1" role="dialog" aria-labelledby="divisionEditModalLabel" aria-hidden="true">
                                    <div class="modal-dialog modal-lg" role="document">
                                        <form action="{{ route('admin.custom-script.update', $data->id) }}" method="POST" enctype="multipart/form-data">
                                            @csrf
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLabel">Custom Script</h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="form-group col-lg-12 col-md-12 col-12">
                                                    <label for="type">Type</label>
                                                    <select class="form-control" name="type" id="type">
                                                        <option value="Head" @if($data->type == 'Head') selected @endif>Head</option>
                                                        <option value="Body" @if($data->type == 'Body') selected @endif>Body</option>
                                                    </select>
                                                </div>
                                                <div class="form-group col-lg-12 col-md-12 col-12">
                                                    <label for="script">Script</label>
                                                    <textarea class="form-control" name="script" id="script" cols="30" rows="3">{{ $data->script }}</textarea>
                                                </div>

                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                                    <button type="submit" class="btn btn-primary">Update</button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
</section>
@endsection

@section('js')
<script src="{{ asset('backend/plugins/datatables/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('backend/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
{{-- <script src="{{ asset('backend/plugins/datatables-responsive/js/dataTables.responsive.min.js') }}"></script> --}}
<script src="{{ asset('backend/plugins/datatables-responsive/js/responsive.bootstrap4.min.js') }}"></script>
<script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>

<script>
    $(function() {
        $("#example1").DataTable({
            "responsive": true
            ,"autoWidth": false
            ,"pageLength": 100
        , });
        $('#example2').DataTable({
            "paging": true
            , "lengthChange": false
            , "searching": false
            , "ordering": true
            , "info": true
            , "autoWidth": false
            , "responsive": true
        });
    });

    function deleteData(id) {
        if (confirm("Are you sure?")) {
            document.getElementById('delete-form-' + id).submit();
        }
        return false;
    }

</script>
@endsection
